(function ($) {
    "use strict";

    // Hamburger-menu
    $('.hamburger-menu').on('click', function () {
        $('.hamburger-menu .line-top, .responsive-menu').toggleClass('current');
        $('.hamburger-menu .line-center').toggleClass('current');
        $('.hamburger-menu .line-bottom').toggleClass('current');
        $("body").toggleClass('menu_active');
    });


    // sticky header
    function sticky_header() {
        var wind = $(window);
        var sticky = $('header');
        wind.on('scroll', function () {
            var scroll = wind.scrollTop();
            if (scroll < 100) {
                sticky.removeClass('sticky');
            } else {
                sticky.addClass('sticky');
            }
        });
    }
    sticky_header();

    // footer-bottom-button-area
    $(document).ready(function () {

        function toggleFooterButton() {
            if ($(window).scrollTop() > 100) {
                $(".footer-bottom-button-area").addClass("show");
            } else {
                $(".footer-bottom-button-area").removeClass("show");
            }
        }

        // Run on page load (refresh)
        toggleFooterButton();

        // Run on scroll
        $(window).on("scroll", function () {
            toggleFooterButton();
        });

    });

    // dental_box
    $(".dental_box").mouseenter(function () {
        $(".dental_box").not(this).removeClass("active");
        $(this).addClass("active");
    });

    // mega_menu
    $(document).ready(function () {

        // Helpers to remove handlers
        function unbindDesktopHandlers() {
            $(".menu_link").off("mouseenter.desktop mouseleave.desktop");
            $(".mega_menu").off("mouseenter.desktop mouseleave.desktop");
        }
        function unbindMobileHandlers() {
            $(".menu_link").off("click.mobile");
            $(document).off("click.mobileOutside");
        }

        /* -------------------------
           DESKTOP HOVER BEHAVIOR
        -------------------------- */
        function setupDesktop() {
            // first remove any mobile handlers
            unbindMobileHandlers();

            // ensure mobile classes are cleared
            $(".mega_menu").removeClass("mobile_sm_active");
            $(".menu_link").removeClass("mobile_sm_active");

            // unbind previous desktop handlers to avoid duplicates
            unbindDesktopHandlers();

            // Bind desktop hover handlers (namespace them so we can remove later)
            $(".menu_link").on("mouseenter.desktop", function () {
                const target = $(this).data("menu");

                $(".mega_menu").removeClass("show");
                $("#" + target).addClass("show");

                $("body").addClass("mega_menu_active");

                $(".menu_link").removeClass("active");
                $(this).addClass("active");
            });

            $(".menu_link").on("mouseleave.desktop", function () {
                const target = $(this).data("menu");

                setTimeout(() => {
                    if (!$("#" + target).is(":hover")) {
                        $("#" + target).removeClass("show");
                        $("body").removeClass("mega_menu_active");
                        $(".menu_link").removeClass("active");
                    }
                }, 100);
            });

            $(".mega_menu").on("mouseenter.desktop", function () {
                $("body").addClass("mega_menu_active");

                let id = $(this).attr("id");
                $(".menu_link").removeClass("active");
                $('.menu_link[data-menu="' + id + '"]').addClass("active");
            });

            $(".mega_menu").on("mouseleave.desktop", function () {
                $("body").removeClass("mega_menu_active");
                $(".mega_menu").removeClass("show");
                $(".menu_link").removeClass("active");
            });
        }

        /* -------------------------
           MOBILE CLICK BEHAVIOR
        -------------------------- */
        function setupMobile() {
            // first remove desktop handlers
            unbindDesktopHandlers();

            // unbind any previous mobile handlers
            unbindMobileHandlers();

            // Ensure desktop classes are cleared
            $(".mega_menu").removeClass("show");
            $(".menu_link").removeClass("active");

            // Mobile click: open/close
            $(".menu_link").on("click.mobile", function (e) {
                // only run mobile logic if small
                if ($(window).width() > 991) return;
                e.preventDefault();
                e.stopPropagation(); // avoid immediate document click

                const target = $(this).data("menu");
                // Close others
                $(".mega_menu").not("#" + target).removeClass("show mobile_sm_active");
                $(".menu_link").not(this).removeClass("mobile_sm_active");

                // Toggle selected
                $("#" + target).toggleClass("show mobile_sm_active");
                $(this).toggleClass("mobile_sm_active");
            });

            // Click inside mega_menu should not close
            $(".mega_menu").on("click.mobile", function (e) {
                e.stopPropagation();
            });

            // Click outside closes everything
            $(document).on("click.mobileOutside", function () {
                if ($(window).width() > 991) return;
                $(".mega_menu").removeClass("show mobile_sm_active");
                $(".menu_link").removeClass("mobile_sm_active");
            });
        }

        /* -------------------------
           Init based on width
        -------------------------- */
        function initMenuByWidth() {
            if ($(window).width() > 991) {
                setupDesktop();
            } else {
                setupMobile();
            }
        }

        // Initial setup
        initMenuByWidth();

        // Recalculate on resize (debounced)
        let resizeTimer;
        $(window).on("resize", function () {
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function () {
                // reset classes and re-init proper handlers
                $(".mega_menu").removeClass("show mobile_sm_active");
                $(".menu_link").removeClass("mobile_sm_active active");
                $("body").removeClass("mega_menu_active");

                initMenuByWidth();
            }, 120);
        });

    });

    $(".mega_menu_toggle").on("click.mobile", function (e) {
        e.stopPropagation();
        $(".mega_menu").removeClass("show mobile_sm_active");
        $(".menu_link").removeClass("mobile_sm_active active");
        $("body").removeClass("mega_menu_active");
    });

    // GLightbox
    const lightbox = GLightbox({
        selector: '.glightbox',
        touchNavigation: true,
        autoplayVideos: true,

    });

    // -----Country Code Selection
    $("#mobile_code").intlTelInput({
        initialCountry: "in",
        separateDialCode: true,
        // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.4/js/utils.js"
    })


})(jQuery);