$(document).ready(function () {

  // selection dropdown

  document.querySelectorAll(".dropdown").forEach(dropdown => {
    const btn = dropdown.querySelector(".dropdown-btn");
    const menu = dropdown.querySelector(".dropdown-menu");
    const selectedText = dropdown.querySelector(".dropdown-selected");
    const items = menu.querySelectorAll("[data-category]");

    btn.addEventListener("click", () => menu.classList.toggle("hidden"));

    items.forEach(item => {
      item.addEventListener("click", () => {
        selectedText.textContent = item.getAttribute("data-category");
        menu.classList.add("hidden");
      });
    });

    // Close when clicking outside
    document.addEventListener("click", e => {
      if (!dropdown.contains(e.target)) {
        menu.classList.add("hidden");
      }
    });
  });

  // selection dropdown


  // accordion js

  document.querySelectorAll('.accordion').forEach((accordion) => {
    const header = accordion.querySelector('.accordion-header');
    const body = accordion.querySelector('.accordion-body');
    const icon = accordion.querySelector('.accordion-icon');

    header.addEventListener('click', () => {
      const isOpen = body.style.maxHeight;

      // Close all
      document.querySelectorAll('.accordion-body').forEach((b) => b.style.maxHeight = null);
      document.querySelectorAll('.accordion-icon').forEach((i) => i.classList.remove('rotate-180'));
      document.querySelectorAll('.accordion-header').forEach((h) => h.classList.remove('trigger'));

      // Toggle clicked one
      if (!isOpen) {
        body.style.maxHeight = body.scrollHeight + 'px';
        icon.classList.add('rotate-180');
        header.classList.add('trigger'); // ✅ add trigger class
      }
    });
  });

  // accordion js



  // offcanva js

  const openMenu = document.getElementById('openMenu');
  const closeMenu = document.getElementById('closeMenu');
  const offcanvas = document.getElementById('offcanvas');
  const backdrop = document.getElementById('backdrop');
  const dropdownToggle = document.getElementById('dropdownToggle');
  const dropdownMenu = document.getElementById('dropdownMenu');
  const dropdownIcon = document.getElementById('dropdownIcon');

  // Open Menu
  openMenu.addEventListener('click', () => {
    backdrop.classList.remove('opacity-0', 'pointer-events-none');
    document.body.classList.add('overflow-hidden');
    document.body.classList.add('menu_active');
  });

  // Close Menu
  const closeOffcanvas = () => {
    backdrop.classList.add('opacity-0', 'pointer-events-none');
    document.body.classList.remove('overflow-hidden');
    document.body.classList.remove('menu_active');
  };

  closeMenu.addEventListener('click', closeOffcanvas);
  backdrop.addEventListener('click', closeOffcanvas);

  // Dropdown Toggle
  dropdownToggle.addEventListener('click', () => {
    dropdownMenu.classList.toggle('hidden');
    dropdownIcon.classList.toggle('rotate-180');
  });

  // offcanva js



  // occasionSlider slider

  var swiper = new Swiper(".occasionSlider", {
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      0: {
        slidesPerView: "auto",
        centeredSlides: true,
        allowTouchMove: true,
      },
      768: {
        slidesPerView: 3,
        allowTouchMove: true,
      },
      1024: {
        slidesPerView: 4,
        allowTouchMove: true,
      },
      1280: {
        slidesPerView: 5,
        allowTouchMove: false,
      },
    },
  });

  // occasionSlider slider



  // teamSlider slider

  var swiper = new Swiper(".teamSlider", {
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
        allowTouchMove: true,
      },
      768: {
        slidesPerView: 2,
        allowTouchMove: true,
        centeredSlides: false,
      },
      992: {
        slidesPerView: 3,
        allowTouchMove: true,
        centeredSlides: false,
      },
      1280: {
        slidesPerView: 4,
        allowTouchMove: false,
      },
    },
  });

  // teamSlider slider



  // testimonial slider

  var swiper = new Swiper(".testimonialSlider", {
    centeredSlides: true,
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
        spaceBetween: 25,
      },
      768: {
        slidesPerView: 2,
        spaceBetween: 0,
        centeredSlides: true,
      },
      1024: {
        slidesPerView: 2,
        spaceBetween: 0,
        centeredSlides: false,
      },
      1200: {
        slidesPerView: 3,
        spaceBetween: 0,
      },
    },
  });

  // testimonial slider



  // planningSlider slider

  var swiper = new Swiper(".planningSlider", {
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
        allowTouchMove: true,
      },
      768: {
        slidesPerView: 2,
        allowTouchMove: true,
        centeredSlides: true,
      },
      1280: {
        slidesPerView: 4,
        centeredSlides: false,
        allowTouchMove: false,
      },
    },
  });

  // planningSlider slider


  // reviewSlider

  var swiper = new Swiper(".reviewSlider", {
    centeredSlides: true,
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    slidesPerView: 1,
  });

  // reviewSlider


  
  // review slider

  var swiper = new Swiper(".review_slider", {
    centeredSlides: true,
    loop: true,
    grabCursor: true,
    spaceBetween: 25,
    touchEventsTarget: 'container',
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    breakpoints: {
      0: {
        slidesPerView: 1,
        spaceBetween: 25,
      },
      768: {
        slidesPerView: 1,
        spaceBetween: 0,
        centeredSlides: true,
      },
      1024: {
        slidesPerView: 1,
        spaceBetween: 0,
        centeredSlides: false,
      },
      1200: {
        slidesPerView: 1,
        spaceBetween: 0,
      },
    },
  });

  // review slider


  // aos animation js

  AOS.init({
    disable: false,
    startEvent: 'DOMContentLoaded',
    initClassName: 'aos-init',
    animatedClassName: 'aos-animate',
    useClassNames: false,
    disableMutationObserver: false,
    debounceDelay: 50,
    throttleDelay: 99,
    offset: 120,
    delay: 0,
    duration: 1500,
    easing: 'ease',
    once: true,
    mirror: false,
    anchorPlacement: 'top-bottom'
  });

  // aos animation js



  // flatpickr js

  // Detect screen width

  const isMobile = window.innerWidth <= 768;

  flatpickr("#selectDate", {
    dateFormat: "Y-m-d",
    monthSelectorType: isMobile ? "dropdown" : "static", // mobile: dropdown, desktop: inline
    yearSelectorType: isMobile ? "dropdown" : "static",
    disableMobile: false, // enables native mobile datepicker if true
    static: !isMobile, // if false, popup aligns below input (better for small screens)
  });

  flatpickr("#selectDate1", {
    dateFormat: "Y-m-d",
    monthSelectorType: isMobile ? "dropdown" : "static", // mobile: dropdown, desktop: inline
    yearSelectorType: isMobile ? "dropdown" : "static",
    disableMobile: false, // enables native mobile datepicker if true
    static: !isMobile, // if false, popup aligns below input (better for small screens)
  });

  flatpickr("#selectDate2", {
    dateFormat: "Y-m-d",
    monthSelectorType: isMobile ? "dropdown" : "static", // mobile: dropdown, desktop: inline
    yearSelectorType: isMobile ? "dropdown" : "static",
    disableMobile: false, // enables native mobile datepicker if true
    static: !isMobile, // if false, popup aligns below input (better for small screens)
  });

  // flatpickr js


})


// ============== site_header ================= //
// Function to toggle the sticky class based on scroll position
function toggleStickyHeader() {
  const header = document.querySelector('.site_header');
  if (!header) return;

  if (window.scrollY > 80) {
    header.classList.add('header_sticky');
  } else {
    header.classList.remove('header_sticky');
  }
}

// Run on scroll
window.addEventListener('scroll', toggleStickyHeader);

// Run once on page load (for refresh mid-scroll)
window.addEventListener('load', toggleStickyHeader);



// ============= initCustomDropdown ============== //
function initCustomDropdown(wrapperSelector) {
  const wrappers = document.querySelectorAll(wrapperSelector);

  wrappers.forEach(wrapper => {
    const btn = wrapper.querySelector(".fillter_btn");
    const list = wrapper.querySelector(".fillter_items");

    if (!btn || !list) return;

    // Toggle dropdown
    btn.addEventListener("click", function (e) {
      e.stopPropagation();

      // Close all others
      document.querySelectorAll(wrapperSelector).forEach(w => {
        if (w !== wrapper) w.classList.remove("active");
      });

      wrapper.classList.toggle("active");
    });

    // Clicking inside items
    list.addEventListener("click", function (e) {
      const clicked = e.target;

      // If click on <a> or <button>, close dropdown
      if (clicked.tagName === "A" || clicked.tagName === "BUTTON") {
        wrapper.classList.remove("active");
      }

      e.stopPropagation();
    });
  });

  // Global click close
  document.addEventListener("click", function () {
    document.querySelectorAll(wrapperSelector).forEach(w => {
      w.classList.remove("active");
    });
  });
}

// Initialize
initCustomDropdown(".fillter_wrap");


// initTabs
function initTabs() {
  document.querySelectorAll('.tab').forEach(tabComponent => {

    const tabButtons = tabComponent.querySelectorAll('.tab_btn');
    const tabPanes = tabComponent.querySelectorAll('[data-tab-content]');

    tabButtons.forEach(btn => {
      btn.addEventListener('click', () => {

        // Remove active states inside this component only
        tabButtons.forEach(b => b.classList.remove('active'));
        tabPanes.forEach(p => p.style.display = 'none');

        // Activate clicked button
        btn.classList.add('active');

        // Show matching pane
        const target = btn.getAttribute('data-tab-btn');
        const pane = tabComponent.querySelector(`[data-tab-content="${target}"]`);

        if (pane) {
          pane.style.display = 'block';
        }
      });
    });

  });
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', initTabs);



// ======== textarea =========== //
const inputs = document.querySelectorAll('input, textarea, select');

inputs.forEach(input => {
  input.addEventListener('focus', () => {
    const parent = input.closest('.form');
    if (parent) {
      parent.classList.add('focused');
    }
  });

  input.addEventListener('blur', () => {
    const parent = input.closest('.form');
    if (parent) {
      parent.classList.remove('focused');
    }
  });
});