(function ($) {
    "use strict";

    // Document Ready
    $(document).ready(function () {

        // Site header
        let lastScrollTop = 0;
        $(window).on("scroll", function () {
            let st = $(this).scrollTop();

            // Only apply logic after crossing 100px
            if (st > 100) {

                
                 if (st > 500) {
                    $(".site_header").addClass("sticky");
                }

                // Scrolling DOWN
                if (st > lastScrollTop) {
                    $(".site_header").addClass("menu_up");
                }

                // Scrolling UP
                else {
                    $(".site_header").removeClass("menu_up");
                }
            }
            else {
                // If user goes above 100px → remove class always
                $(".site_header").removeClass("menu_up");
                $(".site_header").removeClass("sticky");
            }

            lastScrollTop = st;
        });

        // marquee js
        $('.marquee').marquee({
            duration: 30000,
            duplicated: true,
            pauseOnHover: true,
            gap: 0,
            startVisible: true,
            delayBeforeStart: 0,
        });


    });

})(jQuery);
