(function ($) {
    "use strict";

    //Scroll back to top
    $(document).ready(function () {

        var progressPath = document.querySelector('.progress-wrap path');
        var pathLength = progressPath.getTotalLength();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
        progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
        progressPath.style.strokeDashoffset = pathLength;
        progressPath.getBoundingClientRect();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
        var updateProgress = function () {
            var scroll = $(window).scrollTop();
            var height = $(document).height() - $(window).height();
            var progress = pathLength - (scroll * pathLength / height);
            progressPath.style.strokeDashoffset = progress;
        }
        updateProgress();
        $(window).scroll(updateProgress);
        var offset = 50;
        var duration = 550;
        jQuery(window).on('scroll', function () {
            if (jQuery(this).scrollTop() > offset) {
                jQuery('.progress-wrap').addClass('active-progress');
            } else {
                jQuery('.progress-wrap').removeClass('active-progress');
            }
        });
        jQuery('.progress-wrap').on('click', function (event) {
            event.preventDefault();
            jQuery('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })

    });

    // Document Ready
    $(document).ready(function () {

        // menu_toggle
        $('.menu_toggle').on('click', function (event) {
            event.preventDefault();
            $("body").toggleClass('menu_active');
        });

        $(document).ready(function () {
            function toggleSticky() {
                if ($(window).scrollTop() >= 100) {
                    $(".site_header").addClass("sticky");
                } else {
                    $(".site_header").removeClass("sticky");
                }
            }

            // Run once on page load (handles refresh case)
            toggleSticky();

            // Run on scroll
            $(window).on("scroll", function () {
                toggleSticky();
            });
        });

        // marquee
        $('.marquee').marquee({
            duration: 30000,
            duplicated: true,
            pauseOnHover: true,
            gap: 0,
            startVisible: true,
            delayBeforeStart: 0,
        });


        // solution_slider
        new Swiper(".solution_slider", {
            watchSlidesProgress: true,
            watchSlidesVisibility: true,
            speed: 1500,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },

            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },

            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 20
                },
                576: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 25
                },
                992: {
                    slidesPerView: 3,
                    spaceBetween: 40
                }
            }
        });

        // testimonial_slider
        new Swiper(".testimonial_slider", {
            loop: true,
            slidesPerView: 1,
            spaceBetween: 0,
            watchSlidesProgress: true,
            watchSlidesVisibility: true,
            speed: 1500,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            pagination: {
                el: '.swiper-pagination',
                type: "fraction",
            },

        });


    });

})(jQuery);
