(function ($) {
    "use strict";

    // Document Ready
    $(document).ready(function () {

        // initAccordion
        function initAccordion() {
            $(".accordion .accordion_btn").on("click", function () {
                var item = $(this).closest(".accordion_item");
                var body = item.find(".accordion_body");

                // Close others
                $(".accordion_item").not(item).removeClass("active")
                    .find(".accordion_body").slideUp(300);
                $(".accordion_item").not(item).find(".angle_right").removeClass("rotate");

                // Toggle this item
                item.toggleClass("active");
                body.stop(true, true).slideToggle(300);
                item.find(".angle_right").toggleClass("rotate");
            });
        }
        $(document).ready(function () {
            initAccordion();
        });

        // solution_slider
        new Swiper(".solution_slider", {
            navigation: {
                nextEl: ".solution_slider .swiper-button-next",
                prevEl: ".solution_slider .swiper-button-prev",
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            // speed: 1200,
            // autoplay: {
            //     delay: 5000,
            //     disableOnInteraction: false,
            // },
            breakpoints: {
                0: { slidesPerView: 1, spaceBetween: 20 },
                576: { slidesPerView: 1, spaceBetween: 20 },
                768: { slidesPerView: 1, spaceBetween: 25 },
                992: { slidesPerView: 1, spaceBetween: 40 }
            },
        });


    });

})(jQuery);
