(function ($) {
    "use strict";

    // Document Ready
    $(document).ready(function () {

        // initAccordion
        function initAccordion() {
            $(".accordion .accordion_btn").on("click", function () {
                var item = $(this).closest(".accordion_item");
                var body = item.find(".accordion_body");

                // Close others
                $(".accordion_item").not(item).removeClass("active")
                    .find(".accordion_body").slideUp(300);
                $(".accordion_item").not(item).find(".angle_right").removeClass("rotate");

                // Toggle this item
                item.toggleClass("active");
                body.stop(true, true).slideToggle(300);
                item.find(".angle_right").toggleClass("rotate");
            });
        }
        $(document).ready(function () {
            initAccordion();
        });

        // solution_slider
        new Swiper(".solution_slider", {
            navigation: {
                nextEl: ".solution_slider .swiper-button-next",
                prevEl: ".solution_slider .swiper-button-prev",
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            // speed: 1200,
            // autoplay: {
            //     delay: 5000,
            //     disableOnInteraction: false,
            // },
            breakpoints: {
                0: { slidesPerView: 1, spaceBetween: 20 },
                576: { slidesPerView: 1, spaceBetween: 20 },
                768: { slidesPerView: 1, spaceBetween: 25 },
                992: { slidesPerView: 1, spaceBetween: 40 }
            },
        });

        // Open popup
        $(".solution_slider .swiper-slide img").click(function (e) {
            e.stopPropagation(); // stop document click from firing
            var img = $(this).attr('src');
            $('.modal_img img').attr('src', img);
            $('.image_popup').addClass('active');
        });

        // Close with close button
        $(".close_Btn").click(function (e) {
            e.stopPropagation(); // prevent triggering document click
            $('.image_popup').removeClass('active');
        });

        // Click outside popup → close
        $(document).click(function (e) {
            if (!$(e.target).closest('.modal_img').length) {
                $('.image_popup').removeClass('active');
            }
        });

        // Prevent closing when clicking inside modal
        $('.modal_img').click(function (e) {
            e.stopPropagation();
        });


    });

})(jQuery);
