(function ($) {
    "use strict";

    //Scroll back to top
    $(document).ready(function () {

        var progressPath = document.querySelector('.progress-wrap path');
        var pathLength = progressPath.getTotalLength();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
        progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
        progressPath.style.strokeDashoffset = pathLength;
        progressPath.getBoundingClientRect();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
        var updateProgress = function () {
            var scroll = $(window).scrollTop();
            var height = $(document).height() - $(window).height();
            var progress = pathLength - (scroll * pathLength / height);
            progressPath.style.strokeDashoffset = progress;
        }
        updateProgress();
        $(window).scroll(updateProgress);
        var offset = 50;
        var duration = 550;
        jQuery(window).on('scroll', function () {
            if (jQuery(this).scrollTop() > offset) {
                jQuery('.progress-wrap').addClass('active-progress');
            } else {
                jQuery('.progress-wrap').removeClass('active-progress');
            }
        });
        jQuery('.progress-wrap').on('click', function (event) {
            event.preventDefault();
            jQuery('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })

    });

    // Document Ready
    $(document).ready(function () {

        // menu_toggle
        $('.menu_toggle').on('click', function (event) {
            event.preventDefault();
            $("body").toggleClass('menu_active');
        });

        $(document).ready(function () {
            function toggleSticky() {
                if ($(window).scrollTop() >= 100) {
                    $(".site_header").addClass("sticky");
                } else {
                    $(".site_header").removeClass("sticky");
                }
            }

            // Run once on page load (handles refresh case)
            toggleSticky();

            // Run on scroll
            $(window).on("scroll", function () {
                toggleSticky();
            });
        });

        // accordion
        $('.accordion').each(function () {
            const $accordion = $(this);

            // Hide all contents
            $accordion.find('.accordion_content').hide();

            // Open first item by default
            const $firstItem = $accordion.find('.accordion_item').first();
            $firstItem.addClass('active');
            $firstItem.find('.accordion_content').show();

            $accordion.find('.accordion_btn').on('click', function () {
                const $currentItem = $(this).closest('.accordion_item');
                const $currentContent = $currentItem.find('.accordion_content');

                if ($currentItem.hasClass('active')) {
                    $currentContent.stop(true, true).slideUp(300);
                    $currentItem.removeClass('active');
                } else {
                    $accordion.find('.accordion_item.active')
                        .removeClass('active')
                        .find('.accordion_content')
                        .stop(true, true)
                        .slideUp(300);

                    $currentItem.addClass('active');
                    $currentContent.stop(true, true).slideDown(300);
                }
            });
        });

        // read more/less
        $(document).ready(function () {

            // Initial state
            $('.review_qoute').each(function () {
                $(this).find('.more_text').hide();
                $(this).find('.read_less').hide();
            });

            // Read More
            $(document).on('click', '.read_more', function () {
                const $parent = $(this).closest('.review_qoute');

                $parent.find('.more_text').slideDown(200);
                $(this).hide();
                $parent.find('.read_less').show();
            });

            // Read Less
            $(document).on('click', '.read_less', function () {
                const $parent = $(this).closest('.review_qoute');

                $parent.find('.more_text').slideUp(200);
                $(this).hide();
                $parent.find('.read_more').show();
            });

        });

        $(document).ready(function () {

            /* =========================
               DESKTOP (HOVER)
            ========================== */
            $('.dropdown_btn')
                .on('mouseenter.desktop', function () {
                    const id = $(this).data('btn');
                    $('[data-id="' + id + '"]').addClass('active_desktop');
                })
                .on('mouseleave.desktop', function () {
                    const id = $(this).data('btn');
                    const $menu = $('[data-id="' + id + '"]');

                    setTimeout(function () {
                        if (!$menu.is(':hover')) {
                            $menu.removeClass('active_desktop');
                        }
                    }, 10);
                });

            $('.dropdown_menu')
                .on('mouseenter.desktop', function () {
                    $(this).addClass('active_desktop');
                })
                .on('mouseleave.desktop', function () {
                    $(this).removeClass('active_desktop');
                });


            /* =========================
               MOBILE (CLICK)
            ========================== */
            $('.dropdown_btn').on('click', function (e) {
                e.preventDefault();

                const id = $(this).data('btn');
                $('[data-id="' + id + '"]').addClass('active_mobile');
            });

            $('.close_menu').on('click', function () {
                $('.dropdown_menu').removeClass('active_mobile');
            });

        });

        // select_btn
        $(document).on('click', '.dates .select_btn', function (e) {
            e.preventDefault();

            $('.dates .select_btn').removeClass('selected');
            $(this).addClass('selected');

            const target = $(this).attr('href');
            const headerHeight = $('header').outerHeight() || 0;

            if (target && target.startsWith('#') && $(target).length) {
                $('html, body').animate({
                    scrollTop: $(target).offset().top - headerHeight - 50
                }, 600);
            }
        });


        // marquee
        // $('.marquee').marquee({
        //     duration: 20000,
        //     gap: 0,
        //     delayBeforeStart: 0,
        //     direction: 'right',
        //     pauseOnHover: true,
        //     duplicated: true,
        //     startVisible: true,
        // });

        // AOS
        // AOS.init({
        //     duration: 1200,
        //     offset: 200,
        //     easing: 'ease',
        //     once: true,
        //     mirror: false,
        //     anchorPlacement: 'top-bottom',
        // });


        // testimonial_slider
        // new Swiper(".testimonial_slider", {
        //     loop: true,
        //     slidesPerView: 1,
        //     spaceBetween: 0,
        //     watchSlidesProgress: true,
        //     watchSlidesVisibility: true,
        //     speed: 1500,
        //     autoplay: {
        //         delay: 5000,
        //         disableOnInteraction: false,
        //     },
        //     pagination: {
        //         el: ".swiper-pagination",
        //         clickable: true,
        //     },

        // });


        // travels_slider
        new Swiper(".travels_slider", {
            loop: true,
            slidesPerView: 1,
            spaceBetween: 20,
            watchSlidesProgress: true,
            watchSlidesVisibility: true,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
        });

        // review_slider
        new Swiper(".review_slider", {
            slidesPerView: 1,
            spaceBetween: 20,

            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },

            navigation: {
                nextEl: ".review_content .swiper-button-next",
                prevEl: ".review_content .swiper-button-prev",
            },
        });


        // nice-select Initialization
        $('.nice-select').niceSelect();

    });

})(jQuery);
